package breadboards;

/** 
 * Interface required of objects that hold a collection of GObjects
 * @author paul oser
 */
public interface GObjectParent {
  
  /**
   * updates display of containing breadboard (should be called when any contained GObject changes state)
   */
  public void updateDisplay();
  
  /**
  Swaps the z-orders of the specified GObject and the object immediately "above" it.
  * @param gObj the specified GObject
  */
  
  /**
  Swaps the z-orders of the specified GObject and the object immediately "below" it.
  * @param gObj the specified GObject
  */
  public void sendForward(GObject gObj);
  
  /**
  Swaps the z-orders of the specified GObject and the object immediately "below" it.
  * @param gObj the specified GObject
  */
  public void sendBackward(GObject gObj);
  
  /**
   * Moves the specified object "on top" of all other GObjects on the breadboard
   * @param gObj the specified GObject
   */
  public void sendToFront(GObject gObj);
  
  /**
   * Moves the specified object "below" all other GObjects on the breadboard
   * @param gObj the specified GObject
   */
  public void sendToBack(GObject gObj);
  
}
